-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Declarations.OutputDeclarations.PrintDeclarations)
procedure PrintRuleHeader (Write_Rules : in Boolean;
                           Rule_File   : in SPARK_IO.File_Type) is
   OK : Boolean;

   procedure Setup_Family_Name
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     Scope;
   --#           out Rule_Family_Name;
   --# derives Rule_Family_Name from Dictionary.Dict,
   --#                               LexTokenManager.State,
   --#                               Scope;
   is
      Max_Name_Len : constant E_Strings.Lengths := 12;
   begin
      Rule_Family_Name :=
        LexTokenManager.Lex_String_To_String (Lex_Str => Dictionary.GetSimpleName (Dictionary.GetRegion (Scope)));
      if E_Strings.Get_Length (E_Str => Rule_Family_Name) > Max_Name_Len then
         Rule_Family_Name := E_Strings.Section (E_Str     => Rule_Family_Name,
                                                Start_Pos => 1,
                                                Length    => Max_Name_Len);
      end if;
      Rule_Family_Name := E_Strings.Lower_Case (E_Str => Rule_Family_Name);
      E_Strings.Append_String (E_Str => Rule_Family_Name,
                               Str   => "_rules");
   end Setup_Family_Name;

begin --PrintRuleHeader

   --# accept Flow, 10, OK, "Expected ineffective assignment to OK";
   Lists.New_List (Heap     => L_Heap,
                   The_List => Type_List,
                   OK       => OK);
   --# end accept;

   Setup_Family_Name;
   Rule_Counter := 0;

   if Write_Rules then

      SPARK_IO.Put_String (Rule_File, "rule_family ", 0);
      E_Strings.Put_String (File  => Rule_File,
                            E_Str => Rule_Family_Name);
      SPARK_IO.Put_Line (Rule_File, ":", 0);

      SPARK_IO.Set_Col (Rule_File, 2 * Indent);
      SPARK_IO.Put_Line (Rule_File, "X      requires [X:any] &", 0);

      SPARK_IO.Set_Col (Rule_File, 2 * Indent);
      SPARK_IO.Put_Line (Rule_File, "X <= Y requires [X:ire, Y:ire] &", 0);

      SPARK_IO.Set_Col (Rule_File, 2 * Indent);
      SPARK_IO.Put_Line (Rule_File, "X >= Y requires [X:ire, Y:ire].", 0);
      SPARK_IO.New_Line (Rule_File, 1);

   end if;
   --# accept Flow, 33, OK, "Expected OK to be neither referenced nor exported";
end PrintRuleHeader;
