C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE PSSCLF
C                       *****************
C
C      -------------------------------------------------------
     * (NBCOUS,VCOUPS,NELESS,NDMASS,VFCOUS,NODESS)
C      -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNES DU SOLIDE VERS LE SOLIDE               *
C             - dans le cas du traitement des condtions aux limites    *
C               par face, il faut transferer la valeur du flux issu    *
C               du fluide et stockee dans VCOUPS dans VFCOUS           *
C             - dans le cas des solides mobiles, il faut mettre a jour *
C               la temperature exterieure sur les noeuds couples qui   *
C               ne sont pas en face du fluide a ce moment              *
C                                                                      *
C .___________.____.____.______________________________________________.
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NCOUPS   ! TE ! D  ! NUMERO DES NOEUDS SOLIDES COUPLES            !
C !  VCOUPS   ! TR ! D  ! VALEUR AUX NOEUDS SOLIDES COUPLES            !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS SURF SOLIDE COUPLES        !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELEMENTS SOLIDES COUPLES!
C !  NFCOUS   ! TE ! D  ! NUMERO DES FACES  SOLIDES COUPLES            !
C !  VFCOUS   ! TR ! R  ! VALEUR AUX NOEUDS DES FACES SOLIDES COUPLEE  !
C !  NODESS   ! TE ! D  ! TABLE DES ELEMENTS SURF SOLIDE COUPLES       !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES                     !
C !  TRAV1    ! TE ! A  ! TABLEAU DE TRAVAIL                           !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NBCOUS,NDMASS,NELESS,NODESS(NELESS,NDMASS)
      DOUBLE PRECISION VCOUPS(NBCOUS,2),VFCOUS(NELESS,NDMASS,2)
C
C..Variables internes
      INTEGER N,M,NUML,NAFFIC
C
C***********************************************************************
C
C     1- BOUCLES SUR LES FACES COUPLEES
C     ---------------------------------
C
      DO 120 N=1,NELESS
        DO 121 M=1,NDMASS
C
          NUML  = NODESS(N,M)
C
          VFCOUS(N,M,1) = VCOUPS(NUML,1)
          VFCOUS(N,M,2) = VCOUPS(NUML,2)
C
  121   CONTINUE
  120 CONTINUE
C
C
C     3- IMPRESSIONS POUR CONTROLE
C     ============================
      IF (NBLBLA.EQ.14 .OR. NBLBLA.EQ.141) THEN
          IF (NBLBLA.EQ.14) THEN
             NAFFIC=NELESS
          ELSE
             NAFFIC=50
          ENDIF
          WRITE(NFECRA,3000)
          DO 300 N=1,NAFFIC
             WRITE(NFECRA,3010) N,VFCOUS(N,1,1),VFCOUS(N,1,2)
 300      CONTINUE
          CALL FLUSHF(NFECRA)
      ENDIF
C
C
C
C-------
C FORMAT
C-------
C
 3000 FORMAT(/,' *** PSSCLF : CONDITIONS AUX LIMITES SUR LES FACES,',/,
     &     14X,'Passage des donnees des noeuds sur les faces ',/,
     &          5X,' N solide      T        h')
 3010 FORMAT(5X,3X,I10,6X,G13.7,3X,G13.7)
C
C----
C FIN
C----
      END
          
