package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DissociateRouteTablesFromVpcGatewayEndpoint invokes the vpc.DissociateRouteTablesFromVpcGatewayEndpoint API synchronously
func (client *Client) DissociateRouteTablesFromVpcGatewayEndpoint(request *DissociateRouteTablesFromVpcGatewayEndpointRequest) (response *DissociateRouteTablesFromVpcGatewayEndpointResponse, err error) {
	response = CreateDissociateRouteTablesFromVpcGatewayEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DissociateRouteTablesFromVpcGatewayEndpointWithChan invokes the vpc.DissociateRouteTablesFromVpcGatewayEndpoint API asynchronously
func (client *Client) DissociateRouteTablesFromVpcGatewayEndpointWithChan(request *DissociateRouteTablesFromVpcGatewayEndpointRequest) (<-chan *DissociateRouteTablesFromVpcGatewayEndpointResponse, <-chan error) {
	responseChan := make(chan *DissociateRouteTablesFromVpcGatewayEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DissociateRouteTablesFromVpcGatewayEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DissociateRouteTablesFromVpcGatewayEndpointWithCallback invokes the vpc.DissociateRouteTablesFromVpcGatewayEndpoint API asynchronously
func (client *Client) DissociateRouteTablesFromVpcGatewayEndpointWithCallback(request *DissociateRouteTablesFromVpcGatewayEndpointRequest, callback func(response *DissociateRouteTablesFromVpcGatewayEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DissociateRouteTablesFromVpcGatewayEndpointResponse
		var err error
		defer close(result)
		response, err = client.DissociateRouteTablesFromVpcGatewayEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DissociateRouteTablesFromVpcGatewayEndpointRequest is the request struct for api DissociateRouteTablesFromVpcGatewayEndpoint
type DissociateRouteTablesFromVpcGatewayEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RouteTableIds        *[]string        `position:"Query" name:"RouteTableIds"  type:"Repeated"`
}

// DissociateRouteTablesFromVpcGatewayEndpointResponse is the response struct for api DissociateRouteTablesFromVpcGatewayEndpoint
type DissociateRouteTablesFromVpcGatewayEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDissociateRouteTablesFromVpcGatewayEndpointRequest creates a request to invoke DissociateRouteTablesFromVpcGatewayEndpoint API
func CreateDissociateRouteTablesFromVpcGatewayEndpointRequest() (request *DissociateRouteTablesFromVpcGatewayEndpointRequest) {
	request = &DissociateRouteTablesFromVpcGatewayEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DissociateRouteTablesFromVpcGatewayEndpoint", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDissociateRouteTablesFromVpcGatewayEndpointResponse creates a response to parse from DissociateRouteTablesFromVpcGatewayEndpoint response
func CreateDissociateRouteTablesFromVpcGatewayEndpointResponse() (response *DissociateRouteTablesFromVpcGatewayEndpointResponse) {
	response = &DissociateRouteTablesFromVpcGatewayEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
