---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              composition des mathématiques, intégrale
---

# Comment obtenir une intégrale ?

Le signe intégral classique s'obtient avec la commande `\int`. Voici deux
exemples de son utilisation avec une variante sur la position des bornes
de l'intégrale utilisant la commande `\limits`. Cette dernière est présentée
dans la question plus générale 
"[](/4_domaines_specialises/mathematiques/structures/operateurs/changer_la_position_des_limites_autour_des_sommes_et_integrales)".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\diff}[1]{\,\mathrm{d}#1}

\begin{document}
Une intégrale de Gauss de paramètre $ \alpha $ suit la relation suivante :
\[  
  \int_{-\infty}^{+\infty} e^{-\alpha x^2} \,\mathrm{d}x 
  = \sqrt{\frac{\pi}{\alpha}}
\]
En particulier :
\[  \int\limits_{-\infty}^{+\infty} e^{-x^2} \diff{x} = \sqrt{\pi}  \]
\end{document}
```

Vous pourrez noter que l'élément différentiel, "dx", est ici codé 
avec la commmande `\,\mathrm{d}x` (ou, de façon plus pratique par une commande
créée pour l'exemple `\diff`, qui donne un code plus concis et réutilisable) 
afin :
- d'espacer légèrement celle-ci du reste de l'intégrale 
- et d'avoir un `d` en caractères droits. 

Si l'espace est une constante dans la notation mathématique, le `d` se trouve
parfois mis en italique. Le `d` droit est un usage qui semble récent. 


:::{sources}
- [Intégrale notation](https://les-mathematiques.net/vanilla/discussion/771188/integrale-notation),
sur [Les-mathematiques.net](https://les-mathematiques.net/)
:::