---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, sciences, chimie, équation, réaction, mécanisme, électrons
---

# Comment représenter des équations de réaction ?

Pour mettre en forme des équations de réaction, plusieurs extensions sont 
disponibles :
- <ctanpkg:chemformula>, de Clemens Niederberger, permet très simplement 
  d’écrire des équations bilans ;
- <ctanpkg:chemmacros>, du même auteur, fournit les fonctionnalités de
  <ctanpkg:chemformula> ainsi qu'un grand nombre de commandes supplémentaires
  très utiles. De fait, à l'origine, <ctanpkg:chemmformula> était une partie
  de <ctanpkg:chemmacros> mais est maintenant une extension à part entière 
  et dispose de sa propre documentation ;
- <ctanpkg:chemfig>, de Christian Tellechea, permet d'écrire des mécanismes
  réactionnels.


## Équation bilan avec <ctanpkg:chemformula>/<ctanpkg:chemmacros>

### Principe de base

Cette extension est particulièrement simple d’utilisation. Elle fournit 
la commande `\ch{}` qui contient la description des formules et du type
de flèche.


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemmacros}     % ou, ici "chemformula".

\begin{document}
\begin{enumerate}
  \item \ch{CH4 (g) + 2 O2 (g) -> CO2 (g) + H2O (g)}
  \item \ch{MnO4- (aq) + 8 H+ (aq) + 5 e- = Mn^2+ + 4 H2O (l)}
\end{enumerate}
\end{document}
```

Noter qu'il faut bien faire attention à mettre des espaces 
entre les nombres stœchiométriques, les états physiques, et la formule 
de la molécule.


### Noms des espèces 

Vous pouvez facilement ajouter le nom des espèces chimiques 
avec la syntaxe suivante :

```{noedit}
\ch{!(⟨nom de l'espèce⟩)(⟨formule⟩)}
```

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemmacros}     % ou, ici "chemformula".

\begin{document}
\ch{!(Méthane)(CH4 (g)) + !(Dioxygène)(2 O2 (g))
-> !(Dioxyde~de~carbone)(CO2 (g)) + !(Eau)(2 H2O (g))}
\end{document}
```

Par défaut, les chiffres sont placés en indice et les signes en exposants. Pour les
chiffres en exposant, il faut utiliser `^` (les accolades ne sont pas nécessaires).


## Équations bilan avec <ctanpkg:chemfig>

Dans cette partie, la syntaxe de base de l'extension <ctanpkg:chemfig> 
est considérée connue. Si ce n’est pas le cas, vous pouvez vous référer 
à sa documentation <texdoc:chemfig> ou à la question dédiée sur la FAQ
"[](/4_domaines_specialises/sciences/chimie/representer_des_molecules_avec_chemfig)".

L’équation bilan doit être comprise entre les commandes `\schemestart` 
et `\schemestop`.

Vous disposez alors de deux commandes supplémentaires : 
`\arrow(⟨arguments optionnels⟩)` et `\+`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\schemestart
  \chemfig{CH_3 - C (=[:90]O) - OH}
  \+
  \chemfig{CH_3 - CH_2 - OH}
  \arrow(.mid east--.mid west)
  \chemfig{CH_3 - C (=[:90]O) - O - CH_2 - CH_3}
  \+
  \chemfig{H_2O}
\schemestop
\end{document}
```

Vous pouvez noter que, pour aligner la flèche, un argument optionnel 
à la commande `\arrow()` a été ajouté *entre parenthèses*
 

Pour les molécules linéaires cela devrait être souvent le même. Toutefois, 
si l’alignement n’est pas satifaisant, vous trouverez d’autres possibilités dans 
la [documentation](texdoc:chemfig) de <ctanpkg:chemfig>.


## Mécanisme réactionnel avec <ctanpkg:chemfig>

### Étape 1 : donner un nom

Pour simplifier, une première étape peut constituer à attribuer un nom à un
atome ou une liaison avec `@{⟨nom⟩}` placé :
- juste après pour une liaison ;
- juste avant pour un atome.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{
	R-O-C(-[2]R)(-[6]OH)-@{donneur}
	\charge{90=\|,-90=\|}{O}H}
	\hspace{1cm}
	\chemfig{@{accepteur}\charge{
      90:3pt=$\oplus$, 180=\"}{H}
}
\end{document}
```

En réalité nous définissons ici des nœuds. Pour aller plus loin 
sur cette notion, vous pouvez vous reporter à la documentation <texdoc:chemfig>
et/ou à celle de <texdoc:tikz>.

Pour l’instant, rien de plus n'apparaît et c’est normal. Maintenant que
cette étape est faite, vous pouvez utiliser les deux nœuds nommés 
comme points de repère pour représenter le mouvement des électrons.


### Étape 2 : tracer le mouvement des électrons

La commande utilisée pour cela est `\chemmove{}`. Voici un premier exemple
 d’utilisation.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
% formules et création de nœuds
\chemfig{
	R-O-C(-[2]R)(-[6]OH)-@{donneur}
	\charge{90=\|,-90=\|}{O}-H}
	\hspace{1cm}
	\chemfig{@{accepteur}\charge{
      90:3pt=$\oplus$, 180=\"}{H}
}
% mouvement des électrons 
\chemmove{
	\draw[shorten <=2pt, shorten >=3pt]
	(donneur).. controls +(90:1cm) and +(180:1cm).. (accepteur);
}
\end{document}
```

Dans le détail :

- les arguments optionnels de la commande `\draw` permettent de réduire la
  taille de la flèche qui irait sinon jusqu'aux atomes. Nous réduisons ici 
  de 2 points le départ et de 3 points l'arrivée ;
- dans la suite, nous définissons deux points de contrôle pour la courbure
  de la flèche en indiquant *leurs coordonnées polaires* par rapport 
  aux deux nœuds (*donneur* et *accepteur*).

Pour en savoir plus sur ces points de contrôle, vous pouvez vous référer
à la [documentation](texdoc:pgf) de l'extension <ctanpkg:pgf>, partie 2.3.


### Exemple complet

Voici un exemple classique avec l’étape de protonation d’un alcool primaire.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\schemestart
	\chemfig{R - C(=[2]@{donneur}\charge{45=\|,135=\|}{O}) 
	    - \charge{90=\|, -90=\|}{O} - H} 
	\hspace{.5cm}
	\+
	\hspace{.5cm}
	\chemfig{@{accepteur}\charge{180=\", 45:3pt=$\oplus$}{H}}
	\arrow(.mid east--.mid west)
	\chemfig{R - C(=[2]\charge{180=\|,90:3pt=$\oplus$}{O} - H) %
	        - \charge{90=\|, -90=\|}{O} - H} 
\schemestop
\chemmove{
	\draw[shorten <=3pt, shorten >=3pt]
	(donneur).. controls +(45:3cm) and +(180:1cm).. (accepteur);
}
\end{document}
```
