---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, installation de fontes, fontes, 
              polices de caractères, polices PostScript
---

# Comment installer une fonte de type 1 ?

Après avoir récupéré une fonte de type 1, par exemple à partir du CTAN, 
ou après l'avoir [préparé vous-même](preparer_une_fonte_t1),
vous pouvez procéder à l'installation.

La procédure n'est qu'une variante de celle des extensions
de sorte qu'une grande partie de ce qui suit vous sera familier :


## Installer les fichiers dans l'arborescence locale `texmf`

La table suivante donne les destinations usuelles 
pour les différents fichiers relatifs à une famille de polices `⟨nom⟩` :

| Extension      | Chemin                              |
| -------------- | ----------------------------------- |
| `.pfb`, `.pfa` | `.../fonts/type1/⟨fonderie⟩/⟨nom⟩`  |
| `.tfm`         | `.../fonts/tfm/⟨fonderie⟩/⟨nom⟩`    |
| `.vf`          | `.../fonts/vf/⟨fonderie⟩/⟨nom⟩`     |
| `.sty`, `.fd`  | `.../tex/latex/⟨nom⟩`               |
| `.map`         | `.../fonts/map/dvips/⟨fonderie⟩`    |

Mais, si vous avez de la chance, vous utiliserez ici plutôt le fichier `tds.zip` du CTAN 
correspondant à vos fontes : l'utilisation de ce fichier TDS vous évite de décider 
où placer vos fichiers dans l'arbre [TDS](/5_fichiers/emplacements/la_tds).


## Regénérer les index de fichiers

Cette étape est décrite à la question 
"[](/5_fichiers/emplacements/installer_des_fichiers_pour_latex)".


## Mettre à jour les correspondances pour `dvips`, pdfTeX et autres.

### Pour les distributions TeX Live ou teTeX (v3)

Pour cette dernière étape, exécutez, en tant que super-utilisateur, la commande :

```bash
updmap-sys --enable Map ⟨fname⟩.map
```

Si vous ne *pouvez* utiliser `updmap-sys`, 
probablement parce que votre système (La)TeX a été configuré par quelqu'un d'autre,
vous devez vous rabattre sur le simple `updmap`, 
mais soyez conscient que cela peut créer des difficultés 
en configurant des correspondances (les fichiers `.map`) qui peuvent être changés dans votre dos.


### Pour la distribution MiKTeX

Mettez à jour le fichier système `updmap.cfg`, en utilisant la commande :

```bash
initexmf --edit-config-file updmap
```

en ajoutant une ligne à la fin pour chaque famille de fontes ⟨*nom*⟩ que vous ajoutez au système

```text
Map ⟨nom⟩.map
```

Vous pouvez alors générer les correspondances révisées à l'aide de la commande suivante :

```bash
initexmf --mkmaps
```

Cette procédure, et d'autres sujets, sont décrits dans la 
[documentation avancée de MiKTeX](https://docs.miktex.org/manual/advanced.html).

Les deux processus, à savoir la préparation et l'installation d'une police, sont très bien 
(et complètement) décrits dans le [guide d'installation des fontes](ctanpkg:fontinstallationguide)
de Philipp Lehman.

:::{sources}
[Installing a Type 1 font](faquk:FAQ-instt1font)
:::