---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes
---

# Comment utiliser les polices *Latin Modern* ?

Les polices *[Latin Modern](ctanpkg:lm)* sont un ajout intéressant à l'arsenal 
des utilisateurs de (La)TeX : elles disposent de contours de haute qualité 
qui étaient jusqu'à récemment difficiles à obtenir, 
le tout dans une [extension](ctanpkg:lm) gratuite et relativement compacte. 
Cependant, le fichier d'information qui accompagne les polices remarque : 
"Il est supposé que l'utilisateur potentiel sait ce qu'il doit faire 
avec tous ces fichiers". Cette réponse vise à remplir les conditions requises 
et la tâche n'est pas vraiment complexe.

Notez que les distributions de teTeX, à partir de la version 3.0, 
ont déjà les polices <ctanpkg:lm> : tout ce que vous avez à faire, c'est de les utiliser. 
Les polices peuvent également être installées via le gestionnaire d'extension, 
dans un système MiKTeX actuel. 
Le reste de cette réponse s'adresse donc aux personnes qui n'utilisent pas de tels systèmes.

Les fichiers de polices (et autres) apparaissent sur CTAN sous la forme d'arborescence 
[TDS](/5_fichiers/emplacements/la_tds) --- `fonts`, `dvips`, `tex` et `doc`. 
Le sous-répertoire `doc` n'a pas besoin d'être copié 
(c'est en fait une paire de fichiers échantillons), mais copiez les trois autres 
dans votre arbre local `$TEXMF` existant et 
[mettez à jour la base de données des noms de fichiers](/5_fichiers/emplacements/installer_des_fichiers_pour_latex).

Ensuite, ajoutez les polices dans l'ensemble des répertoires où cherchent pdfLaTeX, 
`dvips`, `dvipdfm`/`dvipdfmx`, vos prévisualisateurs et vos programmes de conversion Type 1 vers PK :

- sur un système teTeX antérieur à la version 2.0, éditez le fichier `$TEXMF/dvips/config/updmap` 
  et insérez un chemin absolu pour `lm.map` juste après la ligne qui commence `extra_modules="` 
  (et avant les guillemets fermants) ;

- sur une version 2.0 de teTeX (ou plus récente), exécutez la commande suivante :

```bash
updmap --enable Map lm.map
```

- sur un système MiKTeX antérieur à la version 2.2, l'opération *Refresh filename database* 
  (rafraîchir la base des noms de fichiers) que vous avez effectuée 
  après l'installation des fichiers, met également à jour la "base de données 
  des ressources PostScript" du système ;

- sur un système MiKTeX, version 2.2 ou ultérieure, mettez à jour `updmap.cfg` comme décrit 
  dans la [documentation de MikTeX](https://docs.miktex.org/manual/advanced.html#psfonts).

Pour utiliser les polices dans un document LaTeX, vous devez utiliser la commande 
`\usepackage{lmodern}` qui rendra les polices par défaut pour les trois familles de polices LaTeX 
(romain, sans empattement et chasse fixe). Vous avez également besoin de `\usepackage[T1]{fontenc}`
pour le texte, et `\usepackage{textcomp}` si vous voulez utiliser l'un des symboles d'encodage TS1
(cette dernière extension étant toutefois 
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). 
Il n'y a pas de support pour l'utilisation des polices pour l'encodage OT1.


:::{sources}
[Using the Latin Modern fonts](faquk:FAQ-uselmfonts)
:::
