from typing import Any, Text, Type

from .bucketlistresultset import BucketListResultSet
from .connection import S3Connection
from .key import Key

class S3WebsiteEndpointTranslate:
    trans_region: dict[str, str]
    @classmethod
    def translate_region(cls, reg: Text) -> str: ...

S3Permissions: list[str]

class Bucket:
    LoggingGroup: str
    BucketPaymentBody: str
    VersioningBody: str
    VersionRE: str
    MFADeleteRE: str
    name: Text
    connection: S3Connection
    key_class: Type[Key]
    def __init__(self, connection: S3Connection | None = ..., name: Text | None = ..., key_class: Type[Key] = ...) -> None: ...
    def __iter__(self): ...
    def __contains__(self, key_name) -> bool: ...
    def startElement(self, name, attrs, connection): ...
    creation_date: Any
    def endElement(self, name, value, connection): ...
    def set_key_class(self, key_class): ...
    def lookup(self, key_name, headers: dict[Text, Text] | None = ...): ...
    def get_key(
        self,
        key_name,
        headers: dict[Text, Text] | None = ...,
        version_id: Any | None = ...,
        response_headers: dict[Text, Text] | None = ...,
        validate: bool = ...,
    ) -> Key: ...
    def list(
        self,
        prefix: Text = ...,
        delimiter: Text = ...,
        marker: Text = ...,
        headers: dict[Text, Text] | None = ...,
        encoding_type: Any | None = ...,
    ) -> BucketListResultSet: ...
    def list_versions(
        self,
        prefix: str = ...,
        delimiter: str = ...,
        key_marker: str = ...,
        version_id_marker: str = ...,
        headers: dict[Text, Text] | None = ...,
        encoding_type: Text | None = ...,
    ) -> BucketListResultSet: ...
    def list_multipart_uploads(
        self,
        key_marker: str = ...,
        upload_id_marker: str = ...,
        headers: dict[Text, Text] | None = ...,
        encoding_type: Any | None = ...,
    ): ...
    def validate_kwarg_names(self, kwargs, names): ...
    def get_all_keys(self, headers: dict[Text, Text] | None = ..., **params): ...
    def get_all_versions(self, headers: dict[Text, Text] | None = ..., **params): ...
    def validate_get_all_versions_params(self, params): ...
    def get_all_multipart_uploads(self, headers: dict[Text, Text] | None = ..., **params): ...
    def new_key(self, key_name: Any | None = ...): ...
    def generate_url(
        self,
        expires_in,
        method: str = ...,
        headers: dict[Text, Text] | None = ...,
        force_http: bool = ...,
        response_headers: dict[Text, Text] | None = ...,
        expires_in_absolute: bool = ...,
    ): ...
    def delete_keys(self, keys, quiet: bool = ..., mfa_token: Any | None = ..., headers: dict[Text, Text] | None = ...): ...
    def delete_key(
        self, key_name, headers: dict[Text, Text] | None = ..., version_id: Any | None = ..., mfa_token: Any | None = ...
    ): ...
    def copy_key(
        self,
        new_key_name,
        src_bucket_name,
        src_key_name,
        metadata: Any | None = ...,
        src_version_id: Any | None = ...,
        storage_class: str = ...,
        preserve_acl: bool = ...,
        encrypt_key: bool = ...,
        headers: dict[Text, Text] | None = ...,
        query_args: Any | None = ...,
    ): ...
    def set_canned_acl(
        self, acl_str, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...
    ): ...
    def get_xml_acl(self, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...): ...
    def set_xml_acl(
        self,
        acl_str,
        key_name: str = ...,
        headers: dict[Text, Text] | None = ...,
        version_id: Any | None = ...,
        query_args: str = ...,
    ): ...
    def set_acl(self, acl_or_str, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...): ...
    def get_acl(self, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...): ...
    def set_subresource(
        self, subresource, value, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...
    ): ...
    def get_subresource(
        self, subresource, key_name: str = ..., headers: dict[Text, Text] | None = ..., version_id: Any | None = ...
    ): ...
    def make_public(self, recursive: bool = ..., headers: dict[Text, Text] | None = ...): ...
    def add_email_grant(self, permission, email_address, recursive: bool = ..., headers: dict[Text, Text] | None = ...): ...
    def add_user_grant(
        self, permission, user_id, recursive: bool = ..., headers: dict[Text, Text] | None = ..., display_name: Any | None = ...
    ): ...
    def list_grants(self, headers: dict[Text, Text] | None = ...): ...
    def get_location(self): ...
    def set_xml_logging(self, logging_str, headers: dict[Text, Text] | None = ...): ...
    def enable_logging(
        self, target_bucket, target_prefix: str = ..., grants: Any | None = ..., headers: dict[Text, Text] | None = ...
    ): ...
    def disable_logging(self, headers: dict[Text, Text] | None = ...): ...
    def get_logging_status(self, headers: dict[Text, Text] | None = ...): ...
    def set_as_logging_target(self, headers: dict[Text, Text] | None = ...): ...
    def get_request_payment(self, headers: dict[Text, Text] | None = ...): ...
    def set_request_payment(self, payer: str = ..., headers: dict[Text, Text] | None = ...): ...
    def configure_versioning(
        self, versioning, mfa_delete: bool = ..., mfa_token: Any | None = ..., headers: dict[Text, Text] | None = ...
    ): ...
    def get_versioning_status(self, headers: dict[Text, Text] | None = ...): ...
    def configure_lifecycle(self, lifecycle_config, headers: dict[Text, Text] | None = ...): ...
    def get_lifecycle_config(self, headers: dict[Text, Text] | None = ...): ...
    def delete_lifecycle_configuration(self, headers: dict[Text, Text] | None = ...): ...
    def configure_website(
        self,
        suffix: Any | None = ...,
        error_key: Any | None = ...,
        redirect_all_requests_to: Any | None = ...,
        routing_rules: Any | None = ...,
        headers: dict[Text, Text] | None = ...,
    ): ...
    def set_website_configuration(self, config, headers: dict[Text, Text] | None = ...): ...
    def set_website_configuration_xml(self, xml, headers: dict[Text, Text] | None = ...): ...
    def get_website_configuration(self, headers: dict[Text, Text] | None = ...): ...
    def get_website_configuration_obj(self, headers: dict[Text, Text] | None = ...): ...
    def get_website_configuration_with_xml(self, headers: dict[Text, Text] | None = ...): ...
    def get_website_configuration_xml(self, headers: dict[Text, Text] | None = ...): ...
    def delete_website_configuration(self, headers: dict[Text, Text] | None = ...): ...
    def get_website_endpoint(self): ...
    def get_policy(self, headers: dict[Text, Text] | None = ...): ...
    def set_policy(self, policy, headers: dict[Text, Text] | None = ...): ...
    def delete_policy(self, headers: dict[Text, Text] | None = ...): ...
    def set_cors_xml(self, cors_xml, headers: dict[Text, Text] | None = ...): ...
    def set_cors(self, cors_config, headers: dict[Text, Text] | None = ...): ...
    def get_cors_xml(self, headers: dict[Text, Text] | None = ...): ...
    def get_cors(self, headers: dict[Text, Text] | None = ...): ...
    def delete_cors(self, headers: dict[Text, Text] | None = ...): ...
    def initiate_multipart_upload(
        self,
        key_name,
        headers: dict[Text, Text] | None = ...,
        reduced_redundancy: bool = ...,
        metadata: Any | None = ...,
        encrypt_key: bool = ...,
        policy: Any | None = ...,
    ): ...
    def complete_multipart_upload(self, key_name, upload_id, xml_body, headers: dict[Text, Text] | None = ...): ...
    def cancel_multipart_upload(self, key_name, upload_id, headers: dict[Text, Text] | None = ...): ...
    def delete(self, headers: dict[Text, Text] | None = ...): ...
    def get_tags(self): ...
    def get_xml_tags(self): ...
    def set_xml_tags(self, tag_str, headers: dict[Text, Text] | None = ..., query_args: str = ...): ...
    def set_tags(self, tags, headers: dict[Text, Text] | None = ...): ...
    def delete_tags(self, headers: dict[Text, Text] | None = ...): ...
