/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */
#include "device_form.h"
#include "ui_deviceform.h"
#include <QIcon>
#include <QDebug>
#include <QStyleOption>
#include <QPainter>
#include <QMouseEvent>

DeviceForm::DeviceForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::DeviceForm)
{
    ui->setupUi(this);
//    mov = new QMovie(":/charging.gif");
    setAttribute(Qt::WA_StyledBackground,true);
    ed = EngineDevice::getInstance();
    set_timer();
}

DeviceForm::~DeviceForm()
{
    delete ui;
}

void DeviceForm::set_timer()
{
    charge_animation = new QTimer(this);
    connect(charge_animation,&QTimer::timeout,this,&DeviceForm::begin_charge_animation);

    for(int i = 0; i<=24; i++)
    {
        QString filename = QString(":/charging/%1.png").arg(i);
        animation_list.append(QPixmap(filename));
    }
}

void DeviceForm::set_charge_animation(bool flag)
{
    if(flag)
    {
        if(!charge_animation->isActive())
        {
            charging_index = 0;
            charge_animation->start(200);
        }
    }
    else
    {
        if(charge_animation->isActive())
        {
            charge_animation->stop();
        }
    }
}

void DeviceForm::setIcon(QString name)
{
    if(name.contains("charging"))
    {
        set_charge_animation(true);
        return;
    }
    set_charge_animation(false);
//    QIcon icon = QIcon::fromTheme(name);
    QIcon icon = QIcon(":/charging/0.png");
    QPixmap pixmap = icon.pixmap(QSize(32,32));
    ui->icon->setPixmap(pixmap);
}

void DeviceForm::begin_charge_animation()
{
    ui->icon->setPixmap(animation_list.at(charging_index));
    charging_index ++;
    if(charging_index > 24)
        charging_index = 0;
}

void DeviceForm::setPercent(QString perct)
{
    ui->percentage->setText(perct);
}

void DeviceForm::setKind(QString kind)
{
    ui->kind->setText(kind);
}

void DeviceForm::setRemain(QString remain)
{
    ui->remaintext->setText(tr("RemainTime"));
    ui->remaindata->setText(remain);
}

//void DeviceForm::mousePressEvent(QMouseEvent *event)
//{
//    if(event->buttons() == Qt::LeftButton)
//    {
//        QString cmd = QString("ukui-power-statistics --device %1 &").arg(path);
//        qDebug()<<cmd;
//        system(cmd.toStdString().c_str());
//    }
//}

void DeviceForm::widget_property_change()
{
    setIcon(icon_name);
    setPercent(percentage);
    slider_changed(percent_number);

    setKind(kind);
    setRemain(predict);
}

void DeviceForm::paintEvent(QPaintEvent *event)
{
    QStyleOption opt;
    opt.init(this);
    QPainter p(this);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
    QWidget::paintEvent(event);
}

// void DeviceForm::enterEvent(QEvent *event)
// {
//     Q_UNUSED(event);
//     setStyleSheet(
//                 "background:rgba(61,107,229,1);"
//                 "border-radius:2px;"
//     );
// }

// void DeviceForm::leaveEvent(QEvent *event)
// {
//     Q_UNUSED(event);
//     setStyleSheet(
//                 "QWidget {background-color:rgba(19,19,20,90%);}"
//                 "QProgressBar {"
//                 "width:284px;"
//                 "height:4px;"
//                 "background:rgba(255,255,255,0.1);"
//                 "border-radius:2px;}"

//     );
// }

 QString DeviceForm::calculate_value(int nValue,int nTotal)
 {
     QString strStyle = "";
     int value1 = nTotal * 0.1;
     if (nValue > value1)
     {

         if (nValue > (value1 * 2))
         {

             strStyle = QString("rgba(61,107,229,1)");

         }
         else
         {

             strStyle = QString("rgba(248,163,76,1)");

         }
     }
     else
     {
         strStyle = "rgba(240, 65, 52, 1)";
     }
     return strStyle;
 }

void DeviceForm::set_device(DEVICE *dev)
{
    if(dev == nullptr)
        return;
    m_device = dev;
    path = dev->m_dev.path;
    slot_device_change(dev);
    connect(ed,SIGNAL(signal_device_change(DEVICE*)),this,SLOT(slot_device_change(DEVICE*)));

}

void DeviceForm::slot_device_change(DEVICE* device)
{
    if(device == nullptr)
        return;
    if(device->m_dev.path != path)
        return;
    icon_name = ed->engine_get_device_icon(device);
//    qDebug()<<"slot_device_change------"<<icon_name;
    percentage = QString::number(device->m_dev.Percentage, 'f',0)+"%";
    percent_number = int (device->m_dev.Percentage);
    kind = ed->engine_kind_to_localised_text(device->m_dev.kind,0);
    predict = ed->engine_get_device_predict(device);
    widget_property_change();
}
 void DeviceForm::slider_changed(int value)
 {
     ui->progressBar->setValue(value);
     ui->progressBar->setStyleSheet(QString(""
         "	QProgressBar {"
         "	border-radius: 2px;"
         ""
         "}"
         "QProgressBar::chunk {"
             "border-radius:2px;"
             "	background-color: "
             "%1;"
         "}").arg(calculate_value(value,ui->progressBar->maximum())));
 }
