#!/bin/sh
# prerm script for @@pkg_name@@
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <prerm> `remove'
#        * <old-prerm> `upgrade' <new-version>
#        * <new-prerm> `failed-upgrade' <old-version>
#        * <conflictor's-prerm> `remove' `in-favour' <package> <new-version>
#        * <deconfigured's-prerm> `deconfigure' `in-favour'
#          <package-being-installed> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

case "$1" in
    remove)
      update-alternatives --quiet \
        --remove \
          @@plugin_alternatives_name@@ \
          /usr/lib/uwsgi/plugins/@@plugin_name@@_plugin.so

      update-alternatives --quiet \
        --remove \
          uwsgi \
          /usr/bin/uwsgi_@@plugin_name@@

      PLUGIN_ALTERNATIVES_COUNT="$(\
        update-alternatives --list @@plugin_alternatives_name@@ 2>/dev/null \
        | wc -l \
      )"
      if [ "$PLUGIN_ALTERNATIVES_COUNT" -eq 0 ]; then
        update-alternatives --quiet \
          --remove \
            uwsgi \
            /usr/bin/uwsgi_@@plugin_alternatives_stem@@
      fi
    ;;

    upgrade|deconfigure|failed-upgrade)
    ;;

    *)
        echo "prerm called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

#DEBHELPER#

exit 0
