// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {2216, 3725, 127,  2318, 200,  1655, 3038, 1689, 2145, 1506,
                              931,  595,  1212, 1467, 1988, 610,  3815, 2450, 2452, 3604,
                              3552, 1371, 613,  1288, 2483, 418,  3009, 2301, 3782, 2798,
                              1955, 2142, 2519, 1173, 1372, 3609, 2524, 3789, 1060, 2098};
constexpr int mangledkT2[] = {3633, 3177, 1005, 667,  2676, 2669, 443,  3890, 477,  2192,
                              2479, 2092, 1008, 1769, 3184, 765,  1399, 742,  3116, 2696,
                              89,   421,  2102, 3651, 1015, 3051, 3653, 425,  3015, 2859,
                              3777, 3823, 2021, 371,  855,  169,  2596, 1654, 2910, 1392};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    3391, 1306, 0,    0,    0,    0,    0,    0,    0,    0,    0,    1177,
    0,    0,    0,    0,    846,  0,    0,    0,    0,    0,    0,    0,    475,  0,    2916, 240,
    0,    0,    0,    1114, 0,    2623, 0,    89,   0,    0,    0,    0,    0,    1865, 0,    0,
    2128, 0,    0,    0,    2280, 0,    0,    0,    0,    0,    0,    1760, 0,    799,  1672, 0,
    0,    0,    0,    550,  0,    2959, 0,    0,    0,    0,    0,    0,    3876, 3420, 0,    0,
    0,    145,  0,    1504, 0,    0,    2322, 0,    0,    0,    0,    455,  806,  2991, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    3358, 1989, 0,    0,    1891, 0,    994,  384,  0,
    0,    0,    0,    0,    0,    0,    0,    1165, 0,    0,    0,    3640, 2710, 337,  586,  0,
    0,    0,    0,    0,    3856, 0,    0,    0,    0,    3471, 0,    0,    2587, 0,    0,    0,
    3248, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2587, 0,
    0,    0,    0,    0,    0,    0,    0,    1107, 395,  0,    0,    0,    0,    0,    3487, 0,
    0,    0,    171,  1248, 534,  0,    2322, 0,    0,    1219, 0,    0,    0,    374,  0,    0,
    0,    400,  0,    0,    0,    0,    0,    0,    0,    0,    2028, 0,    0,    0,    2861, 0,
    1246, 0,    0,    0,    1827, 785,  1515, 2529, 396,  3160, 0,    0,    1536, 0,    130,  3124,
    0,    0,    2640, 0,    0,    0,    0,    1078, 0,    0,    0,    0,    0,    0,    523,  0,
    0,    710,  0,    2429, 0,    0,    469,  125,  0,    0,    0,    0,    0,    2539, 2295, 0,
    2953, 2045, 1567, 1549, 0,    0,    1182, 0,    0,    0,    1189, 12,   0,    0,    825,  1610,
    0,    2809, 2576, 0,    915,  0,    0,    3590, 0,    0,    957,  0,    2404, 0,    1210, 933,
    0,    1055, 3237, 0,    82,   967,  0,    0,    886,  0,    0,    0,    0,    2060, 0,    0,
    0,    866,  0,    1383, 2956, 0,    1533, 1265, 0,    1962, 1846, 0,    0,    60,   0,    0,
    0,    282,  849,  0,    0,    0,    0,    0,    0,    3429, 1138, 3410, 0,    0,    0,    0,
    1145, 0,    0,    1716, 2442, 1154, 1486, 0,    0,    0,    0,    0,    0,    3894, 0,    0,
    0,    0,    0,    0,    0,    0,    35,   0,    0,    42,   0,    3799, 0,    0,    0,    3845,
    0,    3148, 1307, 0,    1396, 0,    0,    662,  0,    2662, 3657, 0,    0,    1966, 0,    0,
    1090, 605,  2805, 0,    0,    3323, 0,    833,  0,    116,  0,    531,  0,    915,  0,    0,
    0,    0,    2450, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    888,  0,    835,
    0,    0,    0,    439,  0,    0,    0,    1884, 0,    0,    0,    3296, 0,    0,    0,    2078,
    0,    3622, 0,    1602, 0,    0,    0,    0,    0,    1352, 0,    0,    0,    0,    0,    0,
    0,    0,    2097, 0,    0,    0,    2158, 3419, 683,  0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    1746, 0,    616,  0,    451,  3665, 263,  2364, 1155, 0,    2320, 3516, 1442,
    1230, 0,    2014, 0,    826,  792,  2332, 332,  2014, 822,  0,    0,    0,    3218, 0,    1285,
    0,    1851, 3068, 0,    0,    0,    0,    2129, 178,  0,    12,   0,    3552, 0,    0,    435,
    0,    1344, 2182, 0,    444,  1831, 0,    0,    3666, 1940, 0,    0,    0,    0,    0,    2070,
    1024, 0,    0,    0,    0,    1397, 2174, 0,    0,    0,    1576, 3367, 1033, 1737, 0,    1869,
    1474, 0,    0,    2978, 1675, 2971, 0,    0,    0,    0,    3822, 0,    1263, 2920, 1016, 0,
    2321, 0,    3848, 0,    0,    0,    3654, 0,    0,    649,  0,    0,    0,    2961, 2504, 0,
    763,  1491, 0,    1783, 0,    150,  0,    0,    0,    0,    132,  347,  0,    0,    3648, 1517,
    570,  1928, 0,    1416, 1535, 0,    1674, 1325, 1531, 0,    3879, 1953, 0,    2763, 519,  3641,
    0,    373,  687,  0,    0,    1754, 3304, 0,    2312, 3641, 0,    1430, 0,    0,    0,    0,
    0,    814,  0,    0,    560,  0,    0,    0,    0,    1673, 0,    2735, 3468, 837,  0,    744,
    1919, 0,    0,    0,    0,    0,    0,    0,    237,  3688, 1482, 0,    0,    0,    2447, 0,
    0,    1899, 358,  0,    0,    0,    0,    0,    1699, 0,    3384, 3335, 1950, 0,    0,    0,
    1481, 0,    209,  0,    0,    0,    31,   2969, 0,    0,    0,    0,    0,    0,    0,    0,
    2301, 918,  633,  1216, 0,    78,   1375, 0,    3529, 0,    0,    0,    0,    486,  2797, 0,
    1316, 159,  2470, 0,    1846, 0,    0,    3034, 1322, 0,    150,  0,    0,    2897, 197,  0,
    0,    1945, 3802, 300,  0,    0,    0,    0,    0,    1653, 88,   0,    988,  2114, 0,    1029,
    1887, 0,    1233, 936,  0,    0,    0,    317,  0,    0,    0,    0,    3054, 0,    0,    0,
    2943, 862,  30,   0,    0,    304,  3108, 1846, 0,    45,   686,  0,    3588, 944,  0,    502,
    804,  142,  1547, 3388, 3702, 0,    0,    0,    2383, 3204, 0,    0,    2694, 133,  3604, 1876,
    138,  2994, 3423, 0,    0,    0,    0,    3378, 1939, 1675, 3244, 1325, 0,    0,    0,    0,
    0,    0,    1574, 0,    0,    0,    2233, 565,  0,    1094, 1720, 0,    0,    13,   0,    1073,
    1806, 0,    831,  708,  0,    0,    0,    0,    0,    0,    446,  0,    1472, 640,  688,  924,
    3875, 1366, 0,    1812, 0,    888,  0,    763,  669,  0,    0,    493,  0,    856,  0,    2300,
    0,    0,    0,    0,    3483, 0,    1729, 0,    0,    3295, 492,  0,    3128, 0,    0,    0,
    0,    0,    0,    1076, 0,    0,    502,  269,  0,    0,    1464, 3203, 0,    0,    0,    1865,
    0,    57,   0,    0,    0,    0,    1817, 0,    3330, 1292, 494,  234,  0,    0,    1843, 3460,
    2059, 671,  1457, 875,  2926, 0,    1768, 3532, 283,  0,    3700, 3830, 3641, 3582, 2675, 0,
    1138, 1750, 0,    0,    0,    864,  0,    0,    0,    0,    1967, 2092, 2014, 615,  466,  0,
    2963, 1133, 3580, 1119, 0,    0,    0,    0,    0,    0,    0,    176,  1562, 156,  367,  0,
    431,  3316, 1537, 0,    1553, 0,    0,    820,  1215, 882,  2182, 0,    3873, 0,    1992, 100,
    0,    0,    0,    0,    0,    0,    3268, 1496, 1317, 548,  2767, 172,  0,    0,    0,    0,
    0,    1173, 319,  0,    89,   0,    0,    0,    2950, 2161, 3020, 0,    0,    3061, 0,    2093,
    0,    0,    0,    2358, 0,    0,    2039, 0,    2214, 1555, 863,  0,    0,    0,    0,    0,
    1553, 2749, 630,  2152, 1082, 0,    1582, 521,  279,  798,  1141, 918,  0,    0,    0,    0,
    0,    1144, 1905, 0,    2374, 0,    0,    0,    0,    2942, 531,  2238, 354,  0,    1803, 2068,
    0,    0,    0,    53,   0,    0,    0,    0,    0,    569,  898,  0,    133,  1881, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    48,   3734, 0,    627,  2550, 0,    0,    3376,
    2551, 0,    1529, 0,    0,    1591, 995,  0,    1519, 0,    0,    2050, 0,    3491, 0,    361,
    372,  0,    609,  0,    0,    1369, 0,    0,    0,    1063, 0,    1528, 0,    0,    0,    2667,
    0,    0,    0,    1650, 3655, 3302, 0,    0,    649,  1678, 0,    0,    0,    0,    0,    0,
    0,    891,  0,    0,    0,    0,    0,    2550, 3579, 733,  730,  672,  1225, 0,    0,    3569,
    0,    0,    0,    3534, 0,    2032, 0,    1025, 973,  0,    434,  1252, 1290, 0,    0,    0,
    2243, 0,    0,    0,    1677, 0,    1659, 1203, 1764, 1843, 0,    737,  2377, 0,    2258, 0,
    429,  1115, 0,    1813, 1582, 0,    0,    1125, 2136, 863,  275,  2434, 0,    3744, 0,    479,
    2145, 0,    0,    1113, 2089, 0,    0,    929,  0,    0,    0,    0,    0,    701,  2469, 0,
    0,    0,    648,  0,    0,    293,  501,  1667, 245,  0,    1600, 3431, 0,    0,    1356, 0,
    2283, 2096, 2982, 0,    1189, 0,    0,    3484, 320,  0,    0,    666,  73,   692,  789,  2686,
    0,    77,   1013, 2288, 3007, 0,    0,    0,    0,    1256, 3299, 0,    2504, 34,   1197, 0,
    953,  0,    0,    1382, 0,    0,    0,    0,    3334, 404,  0,    1146, 1551, 1212, 334,  0,
    0,    3375, 0,    748,  1483, 877,  0,    0,    3032, 3014, 0,    0,    2198, 2009, 0,    3597,
    0,    453,  234,  882,  0,    3735, 0,    2022, 1329, 0,    0,    948,  1714, 759,  286,  0,
    1268, 3284, 835,  857,  0,    248,  1125, 3626, 3055, 0,    0,    0,    570,  479,  3518, 0,
    3526, 744,  1212, 0,    3426, 0,    0,    3612, 3703, 2133, 0,    0,    0,    1934, 288,  0,
    1101, 0,    0,    1810, 0,    0,    2923, 0,    178,  0,    0,    1017, 234,  32,   0,    0,
    3772, 369,  0,    1015, 1810, 1931, 0,    1187, 662,  0,    1441, 1282, 0,    0,    455,  3366,
    620,  844,  0,    0,    1799, 0,    395,  0,    0,    3554, 0,    0,    3466, 0,    2691, 1933,
    0,    0,    1117, 0,    0,    0,    0,    2473, 0,    0,    0,    0,    2173, 894,  0,    891,
    0,    2982, 2134, 384,  899,  1011, 3139, 0,    0,    0,    0,    0,    0,    2962, 998,  958,
    0,    3742, 1777, 1029, 87,   0,    2283, 728,  0,    1144, 0,    0,    1451, 1650, 0,    3404,
    836,  198,  3684, 0,    0,    3483, 0,    0,    1318, 3051, 0,    112,  0,    3361, 3,    1446,
    0,    0,    602,  987,  0,    0,    0,    0,    905,  0,    0,    0,    1326, 1508, 0,    1557,
    1322, 0,    1261, 1495, 0,    337,  0,    939,  0,    1526, 1559, 181,  1783, 0,    0,    1639,
    0,    1147, 0,    0,    0,    0,    0,    1167, 66,   904,  1856, 0,    454,  631,  3775, 1668,
    94,   1757, 0,    689,  2982, 3466, 976,  1216, 3854, 0,    2377, 0,    0,    865,  0,    0,
    0,    0,    1834, 1544, 0,    0,    523,  0,    1862, 2388, 0,    0,    444,  0,    0,    2131,
    1766, 2611, 1968, 0,    676,  0,    0,    571,  3802, 0,    394,  0,    0,    395,  0,    1807,
    206,  140,  467,  0,    1960, 0,    439,  0,    372,  1379, 0,    392,  614,  3228, 2190, 0,
    1852, 790,  815,  295,  1100, 0,    0,    437,  0,    0,    2065, 0,    3110, 0,    1551, 240,
    2833, 0,    0,    783,  219,  2919, 3659, 0,    1092, 370,  1740, 749,  0,    0,    0,    1186,
    0,    2035, 0,    3129, 0,    0,    1125, 208,  643,  2802, 0,    1901, 2417, 1584, 3155, 0,
    2143, 684,  1369, 2372, 0,    905,  1264, 694,  3693, 0,    0,    1647, 0,    2265, 0,    306,
    403,  1095, 0,    556,  1057, 0,    0,    0,    0,    2737, 0,    294,  1681, 2958, 0,    0,
    0,    659,  279,  0,    0,    0,    2303, 2042, 0,    0,    1338, 404,  814,  0,    2254, 735,
    0,    2098, 0,    3055, 374,  0,    0,    0,    1879, 2332, 0,    1702, 0,    0,    1653, 3573,
    0,    0,    1936, 2455, 3013, 0,    2443, 0,    0,    0,    0,    3457, 0,    3368, 3784, 2129,
    3827, 534,  0,    3505, 2171, 464,  1698, 1015, 3634, 1350, 2007, 0,    1640, 0,    322,  0,
    0,    2052, 3752, 2344, 0,    0,    2131, 0,    0,    0,    443,  2953, 1696, 124,  3021, 2295,
    174,  1751, 0,    1432, 0,    0,    0,    2137, 1166, 0,    3334, 0,    3060, 0,    0,    2395,
    1083, 2805, 0,    2161, 0,    984,  0,    24,   0,    798,  2121, 1488, 177,  0,    0,    0,
    1740, 3843, 0,    1422, 0,    0,    160,  0,    3545, 3086, 2600, 0,    0,    1551, 1425, 0,
    892,  1614, 0,    450,  3797, 0,    0,    0,    190,  1258, 0,    0,    923,  92,   0,    2608,
    0,    1159, 0,    691,  0,    430,  447,  2959, 1019, 1392, 3731, 2892, 1246, 0,    14,   3426,
    0,    0,    0,    0,    0,    0,    2445, 0,    3583, 0,    707,  228,  269,  1031, 0,    2077,
    3006, 0,    0,    453,  1245, 1243, 0,    3677, 0,    0,    0,    0,    0,    0,    2332, 3703,
    1757, 3669, 798,  37,   2389, 0,    1058, 293,  3167, 1460, 3552, 3717, 0,    0,    709,  341,
    0,    416,  2469, 0,    0,    71,   0,    0,    1180, 1320, 1736, 3121, 0,    323,  0,    0,
    531,  2456, 1489, 0,    0,    0,    0,    0,    3158, 559,  7,    1305, 1365, 159,  0,    0,
    973,  0,    1790, 0,    0,    0,    0,    0,    930,  0,    1776, 199,  3698, 2103, 15,   0,
    0,    3176, 580,  0,    0,    1924, 0,    0,    0,    0,    0,    322,  0,    0,    2656, 440,
    194,  3668, 1921, 1746, 0,    0,    0,    0,    0,    1486, 1795, 1153, 0,    0,    0,    1605,
    1321, 1098, 0,    3642, 0,    0,    86,   1292, 1062, 2897, 815,  0,    3606, 3230, 0,    0,
    125,  0,    0,    2502, 0,    0,    0,    3641, 0,    11,   0,    80,   0,    987,  0,    0,
    10,   0,    995,  3819, 850,  0,    912,  3273, 0,    0,    1834, 2063, 1701, 3169, 682,  0,
    0,    1654, 2707, 3120, 13,   571,  0,    3219, 552,  0,    1384, 0,    3104, 0,    38,   0,
    0,    0,    0,    44,   0,    2715, 0,    3863, 0,    1342, 0,    673,  0,    574,  1515, 429,
    3140, 0,    3368, 2370, 218,  2676, 1996, 2804, 0,    1131, 3352, 738,  849,  372,  0,    194,
    0,    0,    0,    0,    626,  0,    928,  0,    0,    0,    980,  3458, 3123, 333,  0,    0,
    1090, 0,    0,    0,    1765, 749,  0,    0,    0,    0,    0,    2497, 1440, 3227, 689,  0,
    533,  3786, 896,  3352, 1825, 3864, 3663, 1995, 0,    479,  0,    0,    2554, 967,  0,    200,
    107,  0,    1362, 444,  3601, 2887, 754,  1526, 1267, 379,  0,    267,  2281, 2552, 0,    3877,
    2682, 917,  0,    0,    0,    22,   0,    1580, 3833, 0,    2562, 767,  1254, 1523, 1861, 216,
    2004, 0,    1687, 440,  1159, 897,  0,    0,    2839, 691,  0,    0,    817,  0,    938,  3690,
    3454, 1735, 0,    0,    2229, 0,    212,  0,    1522, 0,    117,  0,    0,    0,    1354, 3818,
    0,    66,   0,    0,    3581, 0,    1639, 1670, 1015, 0,    784,  0,    3650, 679,  603,  0,
    0,    0,    0,    0,    250,  3845, 0,    3706, 1663, 0,    813,  1069, 3134, 18,   3433, 422,
    1329, 0,    2484, 0,    0,    0,    157,  1976, 71,   3654, 944,  3742, 13,   3308, 2179, 0,
    1399, 0,    0,    0,    643,  169,  0,    1390, 0,    79,   108,  0,    0,    1110, 0,    0,
    2856, 0,    1756, 3388, 3890, 707,  2699, 0,    1293, 89,   0,    1686, 378,  0,    2559, 0,
    2281, 0,    0,    3717, 0,    0,    0,    761,  731,  0,    0,    407,  0,    321,  2097, 0,
    0,    3905, 0,    388,  0,    151,  3894, 0,    2739, 3375, 1036, 0,    2777, 0,    2457, 0,
    2538, 1493, 3874, 4,    0,    0,    3853, 966,  1889, 554,  700,  1227, 975,  3594, 2959, 512,
    0,    911,  3857, 354,  0,    605,  0,    3823, 460,  0,    2364, 0,    1587, 0,    623,  3520,
    3137, 0,    0,    182,  488,  0,    0,    1325, 675,  3844, 0,    2975, 0,    798,  2109, 0,
    1631, 952,  270,  1228, 1848, 0,    0,    2035, 0,    932,  247,  0,    1484, 291,  0,    146,
    0,    1601, 922,  3217, 200,  2005, 1710, 680,  0,    2253, 1648, 0,    1310, 0,    0,    0,
    1892, 0,    85,   2008, 661,  1972, 0,    2737, 1917, 0,    0,    974,  3607, 418,  3132, 0,
    557,  1301, 3458, 3068, 0,    3143, 2785, 0,    0,    123,  720,  0,    0,    557,  0,    1980,
    1639, 3075, 693,  1130, 911,  3673, 0,    0,    0,    2138, 0,    0,    0,    0,    0,    3190,
    0,    0,    352,  0,    1032, 2589, 990,  22,   1028, 0,    199,  3867, 796,  692,  0,    794,
    0,    0,    0,    1810, 0,    0,    3175, 0,    1271, 0,    0,    1528, 995,  525,  1926, 0,
    3730, 830,  0,    400,  425,  387,  0,    2492, 0,    0,    2595, 1560, 1479, 2578, 0,    0,
    0,    641,  0,    864,  2539, 1525, 0,    0,    0,    371,  0,    1205, 751,  2067, 1566, 0,
    0,    3337, 1785, 0,    1949, 2144, 0,    493,  873,  0,    0,    0,    0,    1990, 2082, 2607,
    0,    0,    1298, 0,    2159, 3583, 0,    1551, 1208, 0,    711,  0,    0,    576,  1511, 2719,
    0,    3604, 668,  1071, 3841, 0,    702,  0,    2939, 0,    745,  1310, 0,    2292, 0,    1574,
    2788, 321,  459,  0,    0,    1576, 0,    0,    983,  423,  0,    0,    1153, 1837, 0,    3788,
    294,  0,    771,  0,    0,    764,  664,  332,  495,  0,    0,    0,    0,    2136, 1855, 285,
    2979, 0,    126,  0,    617,  3189, 0,    877,  0,    0,    652,  896,  0,    0,    0,    646,
    996,  2793, 0,    1034, 3862, 2814, 0,    0,    0,    0,    96,   461,  0,    3474, 432,  0,
    1352, 902,  11,   0,    950,  551,  585,  2579, 158,  0,    1912, 1017, 1821, 0,    0,    0,
    1799, 0,    0,    2467, 0,    1608, 0,    0,    3796, 0,    0,    3125, 0,    0,    126,  1028,
    1669, 0,    1088, 769,  1048, 3307, 2537, 1315, 0,    0,    0,    0,    0,    0,    922,  1607,
    128,  706,  1395, 0,    3108, 2853, 0,    0,    2915, 0,    597,  0,    1505, 3243, 0,    2860,
    0,    0,    0,    1654, 0,    243,  1294, 0,    2489, 3349, 508,  3527, 6,    169,  347,  1959,
    334,  0,    1347, 2786, 3,    3377, 0,    0,    79,   3860, 3442, 1789, 2940, 1737, 0,    336,
    0,    446,  3849, 2011, 0,    0,    2973, 3676, 2196, 0,    0,    3291, 1007, 75,   0,    859,
    0,    2101, 0,    0,    1625, 0,    3569, 317,  3582, 1168, 1593, 303,  0,    597,  286,  0,
    583,  2809, 2137, 393,  3050, 2576, 0,    1691, 0,    1350, 3701, 794,  0,    2426, 811,  108,
    1302, 826,  0,    660,  0,    0,    1659, 0,    0,    339,  0,    0,    2821, 0,    50,   2760,
    0,    0,    0,    358,  3614, 131,  3073, 1083, 0,    748,  680,  3652, 153,  1584, 3340, 1111,
    254,  656,  0,    0,    2256, 289,  171,  0,    1027, 0,    1377, 0,    0,    1490, 360,  1770,
    1578, 839,  606,  0,    320,  2766, 36,   2745, 0,    3133, 1154, 3757, 492,  3404, 642,  0,
    460,  723,  0,    0,    19,   1204, 893,  51,   0,    689,  0,    3374, 1826, 2646, 836,  2128,
    2538, 0,    1319, 0,    0,    3070, 0,    1462, 1726, 3879, 0,    2913, 3324, 2851, 1708, 0,
    3280, 1330, 1134, 0,    522,  989,  0,    3798, 0,    0,    1053, 1449, 3497, 0,    0,    3145,
    1474, 1954, 1099, 0,    0,    3041, 3143, 0,    0,    3214, 1532, 0,    0,    0,    3519, 614,
    3237, 951,  1988, 0,    563,  2058, 3426, 2867, 456,  2051, 93,   1073, 1450, 0,    2033, 158,
    1270, 0,    237,  944,  1527, 3281, 0,    3313, 924,  1370, 1310, 1463, 761,  3886, 838,  0,
    0,    1372, 0,    0,    2531, 0,    2864, 0,    527,  0,    0,    3261, 3329, 468,  190,  0,
    769,  145,  0,    0,    0,    3230, 0,    1358, 3394, 2405, 805,  1132, 0,    0,    0,    0,
    2009, 0,    1640, 1433, 3313, 3647, 0,    0,    1635, 0,    1499, 1873, 431,  301,  0,    2290,
    0,    3550, 1788, 1125, 0,    0,    0,    403,  1488, 947,  2037, 0,    0,    0,    1472, 1415,
    1235, 0,    0,    0,    3319, 3803, 461,  0,    746,  376,  1415, 2485, 0,    0,    572,  1259,
    3748, 2452, 3305, 3544, 3370, 467,  1836, 1828, 0,    2322, 2149, 1070, 2067, 0,    2769, 3174,
    0,    368,  536,  2620, 3887, 2104, 2837, 1482, 0,    3305, 2723, 446,  920,  0,    71,   1564,
    3567, 83,   1342, 259,  0,    376,  0,    1410, 1078, 940,  35,   3291, 757,  0,    0,    3424,
    2135, 1467, 946,  0,    0,    0,    0,    217,  0,    1943, 384,  1782, 2868, 0,    1266, 650,
    0,    1640, 1926, 3332, 0,    1599, 1860, 0,    166,  2483, 1098, 0,    2708, 0,    3354, 1497,
    0,    0,    1027, 1280, 3443, 0,    1224, 687,  32,   1668, 3768, 0,    3262, 0,    1649, 280,
    1175, 2313, 0,    2155, 412,  1745, 1660, 308,  0,    371,  342,  1041, 0,    3862, 0,    0,
    2988, 0,    0,    297,  0,    0,    3842, 0,    0,    206,  0,    1785, 1443, 0,    1753, 0,
    0,    0,    2917, 0,    0,    366,  0,    523,  0,    0,    3554, 2061, 839,  269,  0,    160,
    751,  0,    0,    3709, 1996, 1254, 0,    2189, 0,    28,   1046, 1002, 1481, 0,    483,  1364,
    3192, 0,    0,    3279, 2812, 957,  0,    0,    0,    0,    0,    0,    0,    91,   45,   1186,
    352,  2737, 0,    0,    0,    377,  1156, 2932, 264,  0,    967,  586,  2079, 1744, 1414, 0,
    771,  1348, 3610, 14,   0,    2186, 2640, 1553, 2115, 0,    1213, 0,    304,  643,  0,    1284,
    486,  0,    99,   3684, 0,    184,  2623, 1251, 0,    0,    1570, 2966, 1106, 3860, 0,    1221,
    0,    2764, 1004, 206,  0,    1220, 79,   0,    0,    0,    0,    1166, 0,    24,   3827, 1690,
    0,    3760, 938,  1291, 21,   1016, 3834, 0,    1281, 0,    0,    0,    3758, 3375, 1763, 0,
    2543, 0,    0,    0,    2114, 1491, 0,    0,    105,  1234, 0,    2596, 1442, 2660, 0,    0,
    521,  652,  1496, 743,  0,    0,    720,  0,    3809, 2064, 0,    3825, 0,    677,  1187, 607,
    1060, 1102, 934,  718,  2076, 252,  0,    1707, 3220, 765,  396,  898,  1011, 3484, 3025, 3624,
    2755, 2543, 188,  1468, 2213, 0,    3559, 1873, 0,    1515, 0,    0,    774,  1202, 0,    0,
    3091, 29,   0,    0,    0,    1229, 1648, 1623, 606,  1621, 2589, 2061, 0,    0,    890,  2997,
    3708, 0,    1662, 87,   0,    0,    1390, 1262, 1394, 0,    0,    2944, 2201, 579,  1073, 3890,
    0,    0,    1816, 1140, 1939, 2173, 535,  1070, 0,    0,    1171, 2927, 1238, 2148, 3867, 3754,
    3118, 697,  0,    1455, 649,  365,  1789, 0,    870,  2404, 543,  261,  0,    0,    111,  0,
    0,    0,    217,  3663, 3677, 73,   1509, 614,  728,  969,  0,    1590, 0,    1410, 2526, 1478,
    0,    4,    1543, 0,    233,  907,  0,    0,    0,    0,    593,  3806, 2697, 1130, 192,  3058,
    0,    299,  2108, 117,  2001, 3883, 0,    0,    503,  1519, 0,    2387, 160,  486,  1665, 1754,
    0,    2164, 0,    3345, 0,    1122, 0,    0,    0,    257,  812,  523,  66,   451,  1625, 0,
    3235, 0,    718,  3372, 2427, 49,   3569, 2691, 1531, 1033, 244,  0,    1280, 641,  1502, 945,
    1406, 2494, 3256, 315,  0,    90,   1054, 2028, 3693, 0,    799,  2365, 0,    121,  1915, 876,
    0,    144,  834,  232,  2735, 1452, 1232, 519,  1506, 3456, 491,  0,    2711, 0,    0,    3152,
    0,    3570, 698,  1904, 3864, 2356, 0,    3144, 0,    0,    2363, 614,  763,  482,  1885, 772,
    0,    657,  0,    2827, 1391, 782,  0,    49,   800,  0,    667,  1419, 920,  0,    3185, 0,
    832,  1628, 1649, 0,    0,    0,    0,    657,  0,    0,    1010, 332,  935,  0,    0,    720,
    3754, 1881, 0,    1772, 1428, 1982, 0,    0,    871,  3167, 2168, 0,    3220, 622,  1635, 501,
    0,    0,    3624, 3771, 1755, 0,    623,  1782, 1962, 0,    2629, 0,    295,  3201, 83,   295,
    0,    1230, 0,    3167, 0,    0,    747,  1319, 600,  0,    0,    1055, 4,    1205, 0,    1948,
    3363, 655,  0,    0,    3889, 0,    0,    0,    878,  0,    0,    480,  0,    0,    3440, 3360,
    816,  39,   0,    0,    472,  1761, 350,  0,    0,    3439, 0,    493,  3901, 1129, 0,    0,
    1578, 825,  0,    1773, 0,    0,    1082, 837,  0,    0,    0,    1379, 0,    2256, 3910, 0,
    215,  814,  0,    0,    3282, 3014, 0,    141,  3481, 2554, 0,    0,    3818, 1851, 0,    1074,
    2445, 2186, 683,  3714, 1357, 3871, 2758, 1624, 3480, 0,    0,    3654, 731,  1775, 0,    0,
    0,    0,    0,    0,    0,    0,    821,  671,  0,    1527, 2020, 1556, 668,  0,    1121, 2127,
    2878, 3777, 1337, 685,  3654, 1998, 218,  469,  1414, 1986, 2028, 0,    1096, 2937, 0,    3606,
    0,    3548, 1330, 101,  618,  0,    3436, 526,  0,    0,    2079, 3220, 0,    3238, 0,    1439,
    348,  651,  386,  1226, 706,  1945, 156,  509,  1161, 1501, 11,   0,    0,    2034, 818,  3836,
    1679, 0,    0,    0,    0,    1801, 0,    0,    2720, 1320, 0,    3273, 867,  46,   0,    0,
    530,  0,    0,    2276, 2329, 2849, 1027, 0,    0,    3231, 172,  3655, 3171, 413,  0,    434,
    0,    1921, 687,  0,    0,    1067, 0,    0,    0,    2923, 489,  0,    0,    1886, 1816, 0,
    0,    1127, 0,    0,    0,    0,    0,    0,    2741, 0,    0,    2025, 0,    1905, 0,    3489,
    0,    1753, 0,    1240, 403,  1927, 1273, 2128, 1160, 3648, 524,  1467, 0,    3708, 0,    111,
    0,    1058, 0,    693,  2454, 0,    0,    0,    1507, 2711, 0,    0,    3753, 1413, 3846, 3609,
    552,  0,    1434, 1306, 0,    3063, 3646, 0,    0,    0,    2,    3399, 3173, 208,  0,    1868,
    1225, 718,  1319, 0,    2118, 3026, 413,  1903, 84,   3709, 595,  155,  597,  3644, 1124, 0,
    498,  0,    1177, 1289, 2100, 167,  3288, 3275, 3513, 0,    3695, 748,  316,  3462, 173,  0,
    935,  0,    0,    113,  409,  433,  0,    3216, 2073, 2253, 0,    410,  0,    158,  0,    2633,
    899,  769,  2622, 0,    3636, 1548, 678,  3406, 1585, 1941, 0,    1271, 356,  0,    1625, 0,
    357,  0,    1522, 351,  0,    0,    0,    1856, 3435, 0,    1184, 203,  921,  2654, 0,    656,
    285,  2574, 767,  0,    0,    2515, 0,    472,  0,    192,  0,    0,    0,    1529, 0,    0,
    1881, 1638, 761,  1469, 2025, 0,    1175, 0,    2158, 2518, 0,    1151, 1336, 3649, 1907, 741,
    1223, 0,    709,  0,    2711, 0,    2054, 661,  0,    2413, 0,    2409, 1814, 3709, 1891, 862,
    0,    1229, 0,    1999, 149,  2623, 0,    0,    0};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 3913;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 40)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 3913;
}

constexpr int unmangledkT1[] = {94, 139, 380, 124, 341, 44, 48,  261, 311, 16,  9,  43, 217,
                                67, 311, 39,  117, 290, 46, 267, 80,  308, 127, 71, 57, 156};
constexpr int unmangledkT2[] = {292, 97,  17,  155, 223, 131, 43,  377, 66,  341, 119, 361, 303,
                                381, 179, 105, 242, 114, 260, 237, 234, 191, 248, 258, 340, 364};
constexpr int unmangledkG[]  = {
    0,   0,   0,   0,   0,   0,   0,   169, 0,   179, 0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   364, 0,   0,   0,   0,   0,   0,   243, 188, 316, 68,  0,   34,  187, 25,  11,  0,   0,
    0,   31,  110, 0,   0,   378, 129, 0,   0,   0,   387, 0,   130, 19,  196, 0,   172, 0,   0,
    155, 0,   107, 221, 0,   0,   39,  26,  0,   0,   0,   73,  176, 14,  0,   0,   0,   0,   0,
    343, 0,   0,   0,   248, 101, 7,   0,   294, 225, 0,   0,   0,   0,   0,   0,   14,  0,   0,
    0,   12,  0,   45,  0,   281, 0,   0,   0,   105, 324, 91,  308, 29,  118, 0,   0,   75,  0,
    362, 0,   0,   254, 128, 317, 247, 0,   0,   337, 0,   0,   0,   348, 0,   100, 0,   184, 0,
    343, 0,   0,   192, 95,  0,   333, 125, 203, 0,   93,  0,   369, 373, 29,  0,   0,   137, 372,
    94,  0,   0,   0,   0,   204, 0,   0,   224, 248, 106, 342, 145, 344, 140, 325, 0,   0,   192,
    0,   109, 357, 368, 0,   0,   363, 0,   0,   0,   0,   157, 154, 0,   0,   194, 352, 0,   369,
    244, 0,   0,   192, 363, 0,   44,  365, 0,   0,   277, 52,  0,   97,  0,   0,   117, 158, 0,
    7,   227, 0,   167, 26,  238, 69,  0,   0,   37,  0,   0,   125, 0,   171, 209, 353, 134, 299,
    0,   149, 79,  179, 0,   49,  0,   181, 195, 159, 141, 289, 0,   363, 0,   58,  146, 141, 187,
    0,   0,   260, 62,  0,   189, 134, 0,   0,   301, 0,   0,   191, 195, 0,   0,   0,   194, 24,
    379, 31,  45,  0,   51,  0,   0,   50,  0,   0,   88,  292, 0,   0,   300, 0,   0,   161, 244,
    0,   191, 29,  161, 134, 202, 0,   0,   387, 382, 43,  102, 0,   24,  139, 328, 12,  167, 127,
    185, 129, 371, 326, 0,   0,   101, 242, 0,   177, 341, 148, 0,   0,   0,   328, 0,   196, 145,
    52,  0,   83,  108, 54,  232, 154, 90,  109, 228, 253, 0,   0,   0,   117, 201, 341, 0,   305,
    305, 84,  163, 170, 275, 0,   0,   264, 128, 116, 152, 36,  148, 70,  15,  0,   0,   80,  0,
    98,  0,   0,   102, 0,   225, 141, 111, 0,   183, 0,   266, 0,   223, 260, 0,   0,   0,   222,
    0,   0,   0,   64,  0,   0,   0,   387};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 388;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 26)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 388;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
