/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.util;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DatabaseTestHelper
extends Assert {
    private final Log _log = LogFactory.getLog((Class)(class$org$apache$ddlutils$util$DatabaseTestHelper == null ? (class$org$apache$ddlutils$util$DatabaseTestHelper = DatabaseTestHelper.class$("org.apache.ddlutils.util.DatabaseTestHelper")) : class$org$apache$ddlutils$util$DatabaseTestHelper));
    static /* synthetic */ Class class$org$apache$ddlutils$util$DatabaseTestHelper;

    public void assertHasSameData(Database model, Platform origDbPlatform, Platform testedDbPlatform) {
        this.assertHasSameData(null, model, origDbPlatform, testedDbPlatform);
    }

    public void assertHasSameData(String failureMsg, Database model, Platform origDbPlatform, Platform testedDbPlatform) {
        boolean hasError = false;
        for (int idx = 0; idx < model.getTableCount(); ++idx) {
            Table table = model.getTable(idx);
            Column[] pkCols = table.getPrimaryKeyColumns();
            Iterator it = origDbPlatform.query(model, this.buildQueryString(origDbPlatform, table, null, null), new Table[]{table});
            while (it.hasNext()) {
                DynaBean obj = (DynaBean)it.next();
                List result = testedDbPlatform.fetch(model, this.buildQueryString(origDbPlatform, table, pkCols, obj), new Table[]{table});
                if (result.isEmpty()) {
                    if (this._log.isDebugEnabled()) {
                        hasError = true;
                        this._log.debug((Object)("Row " + obj.toString() + " is not present in second database"));
                        continue;
                    }
                    throw new AssertionFailedError(failureMsg);
                }
                if (result.size() > 1) {
                    if (this._log.isDebugEnabled()) {
                        hasError = true;
                        StringBuffer debugMsg = new StringBuffer();
                        debugMsg.append("Row ");
                        debugMsg.append(obj.toString());
                        debugMsg.append(" is present more than once in the second database:\n");
                        Iterator resultIt = result.iterator();
                        while (resultIt.hasNext()) {
                            debugMsg.append("  ");
                            debugMsg.append(resultIt.next().toString());
                        }
                        this._log.debug((Object)debugMsg.toString());
                        continue;
                    }
                    throw new AssertionFailedError(failureMsg);
                }
                DynaBean otherObj = (DynaBean)result.iterator().next();
                if (obj.equals(otherObj)) continue;
                if (this._log.isDebugEnabled()) {
                    hasError = true;
                    this._log.debug((Object)("Row " + obj.toString() + " is different in the second database: " + otherObj.toString()));
                    continue;
                }
                throw new AssertionFailedError(failureMsg);
            }
        }
        if (hasError) {
            throw new AssertionFailedError(failureMsg);
        }
    }

    private String buildQueryString(Platform targetPlatform, Table table, Column[] whereCols, DynaBean whereValues) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT * FROM ");
        if (targetPlatform.isDelimitedIdentifierModeOn()) {
            result.append(targetPlatform.getPlatformInfo().getDelimiterToken());
        }
        result.append(table.getName());
        if (targetPlatform.isDelimitedIdentifierModeOn()) {
            result.append(targetPlatform.getPlatformInfo().getDelimiterToken());
        }
        if (whereCols != null && whereCols.length > 0) {
            result.append(" WHERE ");
            for (int idx = 0; idx < whereCols.length; ++idx) {
                Object value;
                Object object = value = whereValues == null ? null : whereValues.get(whereCols[idx].getName());
                if (idx > 0) {
                    result.append(" AND ");
                }
                if (targetPlatform.isDelimitedIdentifierModeOn()) {
                    result.append(targetPlatform.getPlatformInfo().getDelimiterToken());
                }
                result.append(whereCols[idx].getName());
                if (targetPlatform.isDelimitedIdentifierModeOn()) {
                    result.append(targetPlatform.getPlatformInfo().getDelimiterToken());
                }
                result.append(" = ");
                if (value == null) {
                    result.append("NULL");
                    continue;
                }
                if (!whereCols[idx].isOfNumericType()) {
                    result.append(targetPlatform.getPlatformInfo().getValueQuoteToken());
                }
                result.append(value.toString());
                if (whereCols[idx].isOfNumericType()) continue;
                result.append(targetPlatform.getPlatformInfo().getValueQuoteToken());
            }
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

