#import <Foundation/Foundation.h>
#import "MockZipArchive.h"

@implementation MockZipArchive : ZipArchive

- (id)initFromFile:(NSString *)file;
{
	NSParameterAssert(file != nil);
	
	// this isn't correct since path represents the output here but that shouldn't matter
	[super initWithPath:file];
	ASSIGN(_output, [NSData dataWithContentsOfFile:file]);
	return self;
}

- (void)dealloc
{
	[_output release];
	[super dealloc];
}

- (NSData *)dataByRunningUnzip
{
	return _output;
}

@end
